/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.ConnectionManagerFactory;
import com.azul.crs.client.InterfaceConnectionManager;
import com.azul.crs.client.Result;
import com.azul.crs.client.Utils;
import com.azul.crs.client.Version;
import com.azul.crs.client.eventconsumer.PostVmData;
import com.azul.crs.client.eventconsumer.VmEventConsumer;
import com.azul.crs.client.service.EventService;
import com.azul.crs.client.service.ServerRequestsService;
import com.azul.crs.client.service.UploadService;
import com.azul.crs.datafilter.SensitiveDataFilterFactory;
import java.io.IOException;
import java.util.Map;
import java.util.function.Predicate;

public final class Client {
    private final InterfaceConnectionManager connectionManager;
    private final UploadService uploadService;
    private final EventService eventService = EventService.getInstance(this);
    private final ServerRequestsService serverRequestsService = new ServerRequestsService();
    private static volatile Utils.Deadline vmShutdownDeadline;
    private final Predicate<String> envFilter;
    private final Predicate<String> sysPropsFilter;
    private final VmEventConsumer eventConsumer;
    private String vmId;

    public Client(Map<ClientProp, Object> map, final ClientListener clientListener) {
        this.connectionManager = ConnectionManagerFactory.create(map, this, new InterfaceConnectionManager.ConnectionListener(){

            @Override
            public void authenticated() {
                Client.this.vmId = Client.this.connectionManager.getVmId();
                clientListener.authenticated();
            }

            @Override
            public void syncFailed(Result<String[]> result) {
                clientListener.syncFailed(result);
            }
        });
        this.uploadService = new UploadService(this);
        SensitiveDataFilterFactory sensitiveDataFilterFactory = new SensitiveDataFilterFactory();
        this.sysPropsFilter = sensitiveDataFilterFactory.createSystemPropertyFilter();
        this.envFilter = sensitiveDataFilterFactory.createEnvironmentFilter();
        this.eventConsumer = new PostVmData(this);
    }

    public VmEventConsumer getVmEventConsumer() {
        return this.eventConsumer;
    }

    public EventService getEventService() {
        return this.eventService;
    }

    public UploadService getUploadService() {
        return this.uploadService;
    }

    public void startup() throws IOException {
        this.connectionManager.start();
        this.eventService.start();
        this.uploadService.start();
        this.serverRequestsService.start();
    }

    public void connectionEstablished() {
        this.eventService.connectionEstablished();
        this.uploadService.connectionEstablished();
    }

    public static boolean isVMShutdownInitiated() {
        return vmShutdownDeadline != null;
    }

    public static void setVMShutdownInitiated(Utils.Deadline deadline) {
        vmShutdownDeadline = deadline;
    }

    public static Utils.Deadline getVMShutdownDeadline() {
        return vmShutdownDeadline;
    }

    public void shutdown(Utils.Deadline deadline) {
        this.eventService.stop(deadline);
        this.uploadService.stop(deadline);
        this.connectionManager.stop(deadline);
        this.serverRequestsService.stop(deadline);
    }

    public void cancel() {
        this.eventService.cancel();
        this.uploadService.cancel();
        this.serverRequestsService.cancel();
    }

    public String getVmId() {
        return this.vmId;
    }

    public String getClientVersion() {
        return new Version().clientVersion();
    }

    public String getClientRevision() {
        return new Version().clientRevision();
    }

    public String getRestAPI() {
        return this.connectionManager.getRestAPI();
    }

    public InterfaceConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public Predicate<String> getEnvFilter() {
        return this.envFilter;
    }

    public Predicate<String> getSysPropsFilter() {
        return this.sysPropsFilter;
    }

    public static enum ClientProp {
        CONNECTION_MANAGER("connection.manager", false),
        API_URL("api.url", true),
        API_MAILBOX("api.mailbox", true),
        KS("keystore", false),
        KSP("keystorepassword", false),
        ACCESS_KEY("accessKey", false),
        HEAP_BUFFER_SIZE("heapBufferSize", false),
        FILE_SYSTEM_BUFFER_SIZE("fileSystemBufferSize", false),
        FILE_SYSTEM_BUFFER_LOCATION("fileSystemBufferLocation", false),
        NUM_CONCURRENT_CONNECTIONS("numConcurrentConnections", false),
        BACKUP_JFR_CHUNKS("backupJfrChunks", false),
        VM_SHUTDOWN_DELAY("delayShutdownInternal", true);

        private final Object value;
        private final boolean mandatory;

        private ClientProp(String string2, boolean bl) {
            this.value = string2;
            this.mandatory = bl;
        }

        Object value() {
            return this.value;
        }

        boolean isMandatory() {
            return this.mandatory;
        }
    }

    public static interface ClientListener {
        public void authenticated();

        public void syncFailed(Result<String[]> var1);
    }
}

