/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Options;
import com.azul.crs.client.Utils;
import com.azul.crs.client.eventconsumer.VmEventConsumer;
import com.azul.crs.client.filter.FiltersFactory;
import com.azul.crs.client.filter.PrefixFilter;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.service.ClassLoadInterface;
import com.azul.crs.util.logging.Logger;
import java.util.HashMap;

public class ClassLoadMonitor
implements ClassLoadInterface {
    private static final Logger logger = Logger.getLogger(ClassLoadMonitor.class);
    private final VmEventConsumer eventConsumer;
    private final PrefixFilter filter = FiltersFactory.getClassLoadFilter();

    public ClassLoadMonitor(VmEventConsumer vmEventConsumer) {
        this.eventConsumer = vmEventConsumer;
    }

    private VMEvent classLoadEvent(String string, String string2, String string3, int n, int n2, String string4, int n3, long l) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("className", string);
        if (string2 != null) {
            hashMap.put("transformedHash", string3);
        }
        hashMap.put("hash", string2 != null ? string2 : string3);
        hashMap.put("classId", Integer.toString(n));
        hashMap.put("loaderId", Integer.toString(n2));
        if (string4 != null) {
            hashMap.put("source", string4);
        }
        if (Options.notifyFirstCall.isYes()) {
            hashMap.put("firstCallPatchingResult", Integer.toString(n3));
        }
        return new VMEvent().eventType(VMEvent.Type.VM_CLASS_LOADED).eventTime(l).eventPayload(hashMap);
    }

    @Override
    public void notifyClassLoad(String string, byte[] byArray, byte[] byArray2, int n, int n2, String string2, int n3) {
        if (!Options.notifyClassLoad.isYes()) {
            return;
        }
        if (this.filter.match(string)) {
            logger.trace("filer out the class=%s", string);
            return;
        }
        long l = Utils.currentTimeMillis();
        String string3 = Utils.encodeToStringOrNull(byArray);
        String string4 = Utils.encodeToStringOrNull(byArray2);
        this.eventConsumer.consumeVMEvent(this.classLoadEvent(string, string3, string4, n, n2, string2, n3, l));
    }

    @Override
    public void notifyClassLoad(String string, byte[] byArray, byte[] byArray2, int n, int n2, String string2) {
        this.notifyClassLoad(string, byArray, byArray2, n, n2, string2, 0);
    }
}

