/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.util.logging;

import com.azul.crs.util.logging.Logger;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class Config {
    private final AtomicReference<Logger.Level> upstream;
    private final AtomicReference<Logger.Level> downstream;
    private final AtomicBoolean upstreamStacktrace;
    private final AtomicBoolean downstreamStacktrace;

    public Config(Logger.Level level, Logger.Level level2, boolean bl, boolean bl2) {
        this.upstream = new AtomicReference<Logger.Level>(level);
        this.downstream = new AtomicReference<Logger.Level>(level2);
        this.upstreamStacktrace = new AtomicBoolean(bl);
        this.downstreamStacktrace = new AtomicBoolean(bl2);
    }

    public Logger.Level getUpstreamLevel() {
        return this.upstream.get();
    }

    public Logger.Level getDownstreamLevel() {
        return this.downstream.get();
    }

    public boolean showUpstreamStacktrace() {
        return this.upstreamStacktrace.get();
    }

    public boolean showDownstreamStacktrace() {
        return this.downstreamStacktrace.get();
    }

    public void reconfigure(Map.Entry<Logger.Level, Boolean> entry, Map.Entry<Logger.Level, Boolean> entry2) {
        if (entry != null) {
            this.downstream.set(entry.getKey());
            this.downstreamStacktrace.set(entry.getValue());
        }
        if (entry2 != null) {
            this.upstream.set(entry2.getKey());
            this.upstreamStacktrace.set(entry2.getValue());
        }
    }
}

